main_func() {
local F="$1";
local perm_arr="$2";
local base_name="${F##*/}";
local j_path="${F%$base_name}";
local util_dir="${0%/*}/bin";
local un_bb="${util_dir}/busybox";
local un_axml="${util_dir}/DumpApkXml";
if [ -n "$j_path" ]; then
cd "$j_path" || ab_ort "Can not 'cd' to
    \"${j_path}\"!";
fi
local start_at="$(date +%H:%M:%S)";
echo "
  App info works...
";
test_zip() {
local test_zfile="$@";
local head_er="$("${un_bb}" hexdump -n 4 -C "$test_zfile" |"${un_bb}" head -n1 |"${un_bb}" cut -f3,4,5,6 -d ' ')";
[ "$head_er" = "50 4b 03 04" ] && echo -n "zip";
}
[ "$(test_zip "$F")" != "zip" ] && ab_ort "File
    \"${F}\"
is not an zip file!";
f_name="${F##*/}";
echo "  File: ${f_name}
";
local sxml_file="$("${un_bb}" unzip -qql "$F" AndroidManifest.xml 2>/dev/null |"${un_bb}" awk '{print $1}' 2>/dev/null)";
[ -z "$sxml_file" ] && ab_ort "File
    AndroidManifest.xml
  is missing!

  Not 'apk' selected?";
echo "  Reading manifest...
";
local a_m_full="$("${un_axml}" "$F" 2>/dev/null)";
echo "$a_m_full" |"${un_bb}" sed -e 's|  *\[|\n|g
s|\].*->.*||g
s|^  *||g
s|^\t\t*||g
s|,  *|\n|g' |"${un_bb}" sed -e '/^$/d
/\@id\/0x/d
/=.*\\/d
/=.*\//d
s|^android:||g' |"${un_bb}" sed -e '/^data$/d
/^scheme=/d
/^host=/d
/^platformBuildVersion/d
s|.*=.*|  \0|g
s|^build |  build |g' |"${un_bb}" sed -e 's|^  *name=|  |g
s|^\([a-z].*[a-z]\)$|\1:|g
s|^\(  *install.ocation=0\)|\1 \[auto\]|g
s|^\(  *install.ocation=1\)|\1 \[internal\]|g
s|^\(  *install.ocation=2\)|\1 \[external\]|g';
echo "
  Done!

  Results:
      Start time: ${start_at}
        End time: $(date +%H:%M:%S)";
exit
}
ab_ort() {
local ar_g="$@";
echo "
  ${ar_g}
";
exit
}
[ -z "$@" ] && ab_ort "No arguments passed!";
[ -e "$@" ] || ab_ort "Object
    \"${@}\"
  does not exist!";
[ -f "$@" ] || ab_ort "Object
    \"${@}\"
  is not a file!";
main_func "$@" || ab_ort "Unknown error!";
exit