main_func() {
local F="$1";
local perm_arr="$2";
local base_name="${F##*/}";
local j_path="${F%$base_name}";
local util_dir="${0%/*}/bin";
local sign_key="${util_dir}/keys/releasekey.x509.pem ${util_dir}/keys/releasekey.pk8";
local un_bb="${util_dir}/busybox";
local un_zi="${util_dir}/zip";
local un_perm="${util_dir}/permissions";
local un_sapk="${util_dir}/apksigner";
local un_zia="${util_dir}/zipalign";
if [ -n "$j_path" ]; then
cd "$j_path" || ab_ort "Can not 'cd' to
    \"${j_path}\"!";
fi
local start_at="$(date +%H:%M:%S)";
echo "
  DelPerms works...
";
test_zip() {
local test_zfile="$@";
local head_er="$("${un_bb}" hexdump -n 4 -C "$test_zfile" |"${un_bb}" head -n1 |"${un_bb}" cut -f3,4,5,6 -d ' ')";
[ "$head_er" = "50 4b 03 04" ] && echo -n "zip";
}
[ "$(test_zip "$F")" != "zip" ] && ab_ort "File
    \"${F}\"
is not an zip file!";
f_name="${F##*/}"; f_name="${f_name%.*}";
echo "  App: ${f_name}
";
local sxml_file="$("${un_bb}" unzip -qql "$F" AndroidManifest.xml 2>/dev/null |"${un_bb}" awk '{print $1}' 2>/dev/null)";
[ -z "$sxml_file" ] && ab_ort "File
    AndroidManifest.xml
  is missing!

  Not 'apk' selected?";
echo "  Patching manifest...";
local new_h="./DelPermission_tmpdir/AndroidManifest.xml";
mk_tmp
"${un_bb}" unzip -ojpq "$F" AndroidManifest.xml >"${new_h}.tmp";
"${un_perm}" -r "$perm_arr" "${new_h}.tmp" "${new_h}" >/dev/null 2>&1;
[ -f "${new_h}" ] || ab_ort "Can not patch this manifest!
  Don't know why!";
"${un_bb}" rm -f "${new_h}.tmp";
cd "./DelPermission_tmpdir" || ab_ort "Can not 'cd' to
    \"./DelPermission_tmpdir\"!";
echo "  Updating manifest...";
"${un_bb}" cp -f "$F" "${F%.*}_delperm.zip";
"${un_zi}" "${F%.*}_delperm.zip" "AndroidManifest.xml" >/dev/null 2>&1;
cd .. || ab_ort "Can not 'cd' to
    \"..\"!";
"${un_bb}" rm -rf "./DelPermission_tmpdir";
echo "  Zipalign file...";
"${un_zia}" -p -f 4 "${F%.*}_delperm.zip" "${F%.*}_delperm.a";
"${un_bb}" rm -f "${F%.*}_delperm.zip";
echo "  Sign file...";
"${un_sapk}" $sign_key "${F%.*}_delperm.a" "${F%.*}_delperm.apk" >/dev/null;
"${un_bb}" rm -f "${F%.*}_delperm.a";
local nxml_file="$("${un_bb}" unzip -qql "${F%.*}_delperm.apk" AndroidManifest.xml 2>/dev/null |"${un_bb}" awk '{print $1}' 2>/dev/null)";
[ -z "$nxml_file" ] && ab_ort "File
    AndroidManifest.xml
  is missing!

  Patched package is broken!";
echo "
  Done!

  Results:
      Start time: ${start_at}
        End time: $(date +%H:%M:%S)
    Old xml size: $((${sxml_file}/1024)) Kb
    New xml size: $((${nxml_file}/1024)) Kb
    File created: ${F%.*}_delperm.apk";
exit
}
ab_ort() {
local ar_g="$@";
echo "
  ${ar_g}
";
[ -e ./DelPermission_tmpdir ] && rm -rf "./DelPermission_tmpdir";
exit
}
mk_tmp() {
"${un_bb}" mkdir -p "./DelPermission_tmpdir" || ab_ort "Can not create
    \"./DelPermission_tmpdir\"
  directory!";
}
[ -z "$2" ] && ab_ort "No arguments passed!";
[ -e "$1" ] || ab_ort "Object
    \"${1}\"
  does not exist!";
[ -f "$1" ] || ab_ort "Object
    \"${1}\"
  is not a file!";
main_func "$@" || ab_ort "Unknown error!";
exit
